Call run_SRH_1D

result = MsgBox ("Successful start of all SRH-1D simulations", vbOK, "Script Execution")

Sub run_SRH_1D
	
	Const MAX_RUNS = 100
	Dim prog_name, file_path, command_line_str, return_val
	Dim i, j, flag
	Dim WshShell, oExec(), run_status()
	Dim fso, f, f1, fc, gis_file,txt_file, input_file
	Dim sf,sf1
	Dim used_processors , max_processors
	
	Const LOW = 64
	Const BELOW_NORMAL = 16384
	Const NORMAL = 32
	Const ABOVE_NORMAL = 32768
	Const HIGH = 128
	
	ReDim oexec(MAX_RUNS)
	ReDim run_status(MAX_RUNS)

	result = MsgBox ("This script will run simulations for all files with a srh extension. Hit ok to continue, Cancel to exit.", _
	    vbOKCancel, "Script Execution")
	
	Select Case result
	Case vbOK
	
	Case vbCancel
		Exit Sub
	End Select

	For j = 1 To MAX_RUNS
		run_status(j) = 1
	Next 
	
	Set WshShell = WScript.CreateObject("WScript.Shell")
	Set fso = CreateObject("Scripting.FileSystemObject")
	file_path = WshShell.CurrentDirectory
	
	Set WshShell = WScript.CreateObject("WScript.Shell")
	Set WshSysEnv = WshShell.Environment("SYSTEM")
	max_processors = Int(WshSysEnv("NUMBER_OF_PROCESSORS"))
'	min_processors = 1
'	max_processors  = Max(max_processors,min_processors)
	
	Set f = fso.GetFolder(file_path)
	
	used_processors = 0
	
	Set fc = f.Files
	
'***************************************************************************		
' ENTER LOCATION OF  SHR-1D file here:		
		prog_name ="..\..\exe\SRH-1D V4.0.exe"
'***************************************************************************		
	i = 0
	For Each f1 in fc
		If i > MAX_RUNS Then
			 WScript.echo "Maximum number of simulations exceeded"
			 Exit For
		End If
		If Right(f1,3) = "srh" Then
			input_file = """" & f1.name & "\" & f1.name & """"
' run program		(add "-e" to exit without prompt)
	'		command_line_str = prog_name & " -e " & input_file 
			command_line_str = prog_name & " " & input_file 
	
	'		return_val = WshShell.run(command_line_str,1,true)		
			i = i + 1		
			Set oExec(i) = WshShell.Exec(command_line_str)	

			strComputer = "."
			Set objWMIService = GetObject("winmgmts:" _
			    & "{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")
'***************************************************************************		
' ENTER name OF SHR-1D executable on line below:		
'***************************************************************************					    
			Set colProcesses = objWMIService.ExecQuery _
			    ("Select * from Win32_Process Where Name = 'SRH-1D V4.0.exe'")
			For Each objProcess in colProcesses
			    objProcess.SetPriority(BELOW_NORMAL) 
			Next		
			
			used_processors = used_processors + 1
			WScript.Sleep 2000
			Do While used_processors >= max_processors
				WScript.Sleep 1000							
				flag = 1
				For j = 1 To i
					If oExec(j).status <> 0 And run_status(j) <> 0 Then
						run_status(j) = 0
						used_processors = used_processors - 1
						flag = 0
					End If
				Next 
				If flag = 0 Then
					Exit Do
				End If
			Loop
		End If
	Next
	
End Sub